<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    /**
     * [Description for index]
     *
     * @return [type]
     *
     */
    public function index()
    {
        //
    }
    /**
     * [Used to return view of create new employee]
     *
     * @return [type]
     *
     */
    public function create()
    {
        //
    }

    public function resetPassword(Request $request)
    {
        Validator::validate(
            $request->all(),
            [
                'password' => 'required|same:password_confirmation|min:5|max:50',
                'password_confirmation' => 'required|min:5|max:50',
                // 'nameCertificate'=>'required|min:10|max:50'
            ],
            [
                'password.required' => 'يجب تعبئت كلمة المرور',
                'password.min' => 'يجب أن تكون كلمة المرور اكثر 5 احرف',
                'password.max' => 'يجب أن تكون كلمة المرور اقل من 50 حرف',
                'password.same' => 'يجب أن تكون كلمة المرور متساوية مع اعادة كلمة المرور',
                'password_confirmation.required' => 'يجب تعبئت  كلمة المرور الجديدة',
                'password_confirmation.min' => 'يجب أن تكون  كلمة المرور اكثر 5 احرف',
                'password_confirmation.max' => 'يجب أن تكون  كلمة المرور اقل من 50 حرف',
                // 'nameCertificate.required' => 'يجب تعبئت  اسمك الذي سيظهر في الشهادة الجديدة',
                // 'nameCertificate.min' => 'يجب أن يكون  اسمك الذي سيظهر في الشهادة اكثر 5 احرف',
                // 'nameCertificate.max' => 'يجب أن يكون  اسمك الذي سيظهر في الشهادة اقل من 50 حرف',
            ]
        );
        if (Auth::user()->role == 2) {
            Validator::validate(
                $request->all(),
                [
                    'password' => 'required|same:password_confirmation|min:5|max:50',
                    'password_confirmation' => 'required|min:5|max:20',
                    'nameCertificate' => 'required|min:10|max:35',
                ],
                [
                    'password.required' => 'يجب تعبئت كلمة المرور',
                    'password.min' => 'يجب أن تكون كلمة المرور اكثر 5 احرف',
                    'password.max' => 'يجب أن تكون كلمة المرور اقل من 50 حرف',
                    'password.same' => 'يجب أن تكون كلمة المرور متساوية مع اعادة كلمة المرور',
                    'password_confirmation.required' => 'يجب تعبئت  كلمة المرور الجديدة',
                    'password_confirmation.min' => 'يجب أن تكون  كلمة المرور اكثر 5 احرف',
                    'password_confirmation.max' => 'يجب أن تكون  كلمة المرور اقل من 20 حرف',
                    'nameCertificate.required' => 'يجب تعبئت  اسمك الذي سيظهر في الشهادة الجديدة',
                    'nameCertificate.min' => 'يجب أن يكون  اسمك الذي سيظهر في الشهادة اكثر 5 احرف',
                    'nameCertificate.max' => 'يجب أن يكون  اسمك الذي سيظهر في الشهادة اقل من 35 حرف',
                ]
            );
        }

        try {
            $newUser = User::find(Auth::id());
            $newUser->email = $request->email;
            $newUser->password = Hash::make($request->password);
            $newUser->is_reset = 1;
            if (Auth::user()->role == 2) {
                $newUser->certificate_name = $request->nameCertificate;
            }

            $newUser->update();
            switch (Auth::user()->role) {
                case 0:
                    return redirect('/admin')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);
                    break;

                case 1:
                    return redirect('/trainer')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);

                    break;

                case 2:
                    return redirect('/student')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);

                    break;
                case 3:
                    return redirect('/coordinator')->with(['success' => 'لقد تم اعادة تعيين كلمة المرور الخاصة بك بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);

                    break;
                default:
                    return redirect('/');

                    break;
            }
            return back()->with(['success' => 'تم تغيير كلمة المرور بنجاح, يمكنك الان الاستفادة من خدمات المنصة']);
        } catch (\Throwable$th) {
            return redirect()->back()->with(['error', 'هناك خطأ يرجى مراجعة الدعم الفني']);
        }
    }

    /**
     * [Description for register]
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function store(Request $request)
    {

        //
    }

    public function login(Request $request)
    {

        //
    }

    public function logout()
    {
        //
    }

    public function refresh()
    {
        //
    }
}
